/* ----------------------------------------------------------------------------
 *         ATMEL Microcontroller Software Support
 * ----------------------------------------------------------------------------
 * Copyright (c) 2006, Atmel Corporation
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer below.
 *
 * Atmel's name may not be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * DISCLAIMER: THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include "common.h"
#include "board.h"
#include "usart.h"
#include "slowclk.h"
#include "board_hw_info.h"
#include "tz_utils.h"
#include "pm.h"
#include "act8865.h"
#include "secure.h"
#include "sfr_aicredir.h"
#include "debug.h"

#ifdef CONFIG_HW_DISPLAY_BANNER
static void display_banner (void)
{
	usart_puts(BANNER);
}
#endif

//typedef void (*void_function_pointer)(void);

int main(void)
{
	struct image_info image;
	int ret;

//	void_function_pointer	uboot_pointer;

#ifdef CONFIG_HW_INIT
	hw_init();
#endif

#if defined(CONFIG_SCLK)
#if !defined(CONFIG_SCLK_BYPASS)
	slowclk_enable_osc32();
#endif
#endif

#ifdef CONFIG_HW_DISPLAY_BANNER
	display_banner();
#endif

#ifdef CONFIG_REDIRECT_ALL_INTS_AIC
	redirect_interrupts_to_nsaic();
//	dbg_info("main: end of redirect_interrupts_to_nsaic()\n");
#endif

#ifdef CONFIG_LOAD_HW_INFO
	load_board_hw_info();
//	dbg_info("main: end of load_board_hw_info()\n");
#endif

#ifdef CONFIG_PM
	at91_board_pm();
//	dbg_info("main: end of at91_board_pm()\n");
#endif

#ifdef CONFIG_ACT8865
	act8865_workaround();
//	dbg_info("main: end of act8865_workaround()\n");
	act8945a_suspend_charger();
//	dbg_info("main: end of act8945a_suspend_charger()\n");
#endif

//	dbg_info("main: DRAM check\n");
//	for(ret = JUMP_ADDR; ret<(JUMP_ADDR + 0x100); )
//	{
//		*(unsigned char *)ret = (unsigned char)ret;
//		ret++;
//	}
//	ret = JUMP_ADDR;
//	dbg_hexdump((const unsigned char *)ret, 0x100, DUMP_WIDTH_BIT_8);

	init_load_image(&image);
//	dbg_info("main: end of init_load_image()\n");

#if defined(CONFIG_SECURE)
	image.dest -= sizeof(at91_secure_header_t);
#endif

	ret = (*load_image)(&image);
	dbg_info("main: end of load_image() image.dest = %x\n", image.dest);
	dbg_info("main: end of load_image() image.offset = %x\n", image.offset);
	dbg_info("main: end of load_image() return = %d\n", ret);

#if defined(CONFIG_SECURE)
	if (!ret)
		ret = secure_check(image.dest);
	image.dest += sizeof(at91_secure_header_t);
#endif

	load_image_done(ret);

#ifdef CONFIG_SCLK
#ifdef CONFIG_SCLK_BYPASS
	slowclk_switch_osc32_bypass();
//	dbg_info("main: end of slowclk_switch_osc32_bypass()\n");
#else
	slowclk_switch_osc32();
//	dbg_info("main: end of slowclk_switch_osc32()\n");
#endif
#endif

#if defined(CONFIG_ENTER_NWD)
	switch_normal_world();

	/* point never reached with TZ support */
#endif
//	dbg_printf("main: jump to 0x%X\n", JUMP_ADDR);
//	dbg_hexdump((const unsigned char *)JUMP_ADDR, 0x100, DUMP_WIDTH_BIT_8);
//	dbg_printf("main: jump to 0x%X\n", JUMP_ADDR);
//	dbg_hexdump((const unsigned char *)JUMP_ADDR, 0x100, DUMP_WIDTH_BIT_8);

	for(ret = 0; ret<0x700000; )
	{
		ret++;
	}
//	dbg_printf("main: jump to 0x%X\n", JUMP_ADDR);
//	dbg_hexdump((const unsigned char *)JUMP_ADDR, 0x100, DUMP_WIDTH_BIT_8);

//	uboot_pointer = (void_function_pointer)JUMP_ADDR;
//	uboot_pointer();
	((void (*)(void))(JUMP_ADDR))();

//	dbg_printf("main: jump to 0x%X\n", JUMP_ADDR);
//	dbg_hexdump((const unsigned char *)JUMP_ADDR, 0x100, DUMP_WIDTH_BIT_8);

	//	asm ("mov 	r1, #MACH_TYPE");
//	asm ("mov   r0, #JUMP_ADDR");
//	asm ("bX    r0");
	return JUMP_ADDR;
}
